﻿XIncludeFile "gDrawing.pbi"

Global pbLogo

Procedure DrawTo( output )
    If gStartDrawing( output )
        gClear($FFFFFFFF)

        gSetUnit(#UnitMillimeter)               ; use millimeters
    
        pensize.f = 0.1                         ; 0.1mm
        
        gSetPen(RGBA($00,$00,$00,$FF),pensize)
        gSetFont("Arial",40)                    ; fontheight is 40mm

        gDrawingMode(#PB_2DDrawing_Outlined)
        ;gDrawingMode(#PB_2DDrawing_Default)
        gDrawText(5, 5, "gDrawing")             ; draw text at 5mm , 5mm

        gDrawingMode(#PB_2DDrawing_Outlined)
        h = gTextHeight()
        gBox(5,5,gTextWidth("gDrawing"),h)

        gSetPenAlignment(#PenAlignmentInset)
        gSetPenSize(1)                          ; pen size 1mm
        gBox(5,10+h,100,100)                    ; box is 100mm x 100mm
        gLine(6,11+h,98,98)
        gSetFont("Arial",10)
        gDrawingMode(#PB_2DDrawing_Default)
        gDrawText(105,10+h,Str(gGetDpiX())+" x "+Str(gGetDpiY())+" DPI");, RGBA(0,0,0,$FF))
        
        pensize = 0.01
        For i = 0 To 30
            gSetPenSize(pensize)                          ; pen size in mm
            gLineXY(110+i*3,30+h,110+i*3,80+h,$FF000000)
            pensize + 0.05
        Next i
        
        gDrawImage(pbLogo,15,80+h,40,20)            ; 40mm x 20mm

        gDrawAlphaImage(pbLogo,60,80+h,40,20,0.5)   ; 40mm x 20mm - doesnt work with some PDF printers if they dont support transparency

        ;DrawImage(ImageID(pbLogo),10,10)
        
        ;DrawAlphaImage(ImageID(pbLogo),10,80,172)

        gStopDrawing()
    EndIf
EndProcedure

pbLogo = LoadImage(#PB_Any,#PB_Compiler_Home+"Examples\Sources\Data\PureBasicLogo.bmp")
If Not pbLogo : MessageRequester("ERROR","Unable to load PureBasic logo!") : End : EndIf


If gInit()
    mainWin = OpenWindow(#PB_Any,0,0,800,600,"gDrawing printer test 01",#PB_Window_SystemMenu|#PB_Window_ScreenCentered)
    img = CreateImage(#PB_Any,800,600,24)
    DrawTo( ImageOutput(img) )
    imgWin  = ImageGadget(#PB_Any,0,0,800,600,ImageID(img))

    Repeat : Until WaitWindowEvent()=#PB_Event_CloseWindow

    If PrintRequester()
        If StartPrinting("gDrawing Print Test 01")

            DrawTo( PrinterOutput() )

            StopPrinting()
        EndIf
    EndIf
    gEnd()
EndIf

; IDE Options = PureBasic 4.51 (Windows - x86)
; CursorPosition = 42
; FirstLine = 3
; Folding = -
; EnableUnicode
; EnableXP
; Executable = gDrawing PrintTest 01.exe
; CPU = 5